package MusicLandscape.entities;

/**
 * This class represents a music video as a concrete release of a specific artist.<br>
 * A music video is a video presentation for a single track and has the same duration as the track.
 *
 * @author Jonas Altrock (ew20b126@technikum-wien.at)
 * @version 1
 * @since ExerciseSheet04
 */
public class MusicVideo extends Release {
    /**
     * The track of this music video.
     */
    private Track track;

    /**
     * Default constructor.
     */
    public MusicVideo() {

    }

    /**
     * Gets the track of this music video.
     *
     * @return the track
     */
    public Track getTrack() {
        return track;
    }

    /**
     * Sets the track of this music video.
     * @param track the track to set
     */
    public void setTrack(Track track) {
        this.track = track;
    }

    /**
     * Gets the total running time of this music video.
     *
     * @return the total running time in seconds.
     */
    @Override
    public int totalTime() {
        if (track == null) {
            return 0;
        }
        return track.getDuration();
    }

    /**
     * Gets a String representation of this music video.
     * <p>
     * The String representation of a music video simply adds "-(Video)" (without quotes) to the String representation
     * of a general release.
     *
     * @return the string representation
     */
    @Override
    public String toString() {
        return super.toString() + "-(Video)";
    }
}
